<?php 


class Receipts_model extends CI_MODEL {


// ========Insert Recipts================

 public function get_receipt_datas() {
    $this->db->distinct();  // Ensure unique results
	$this->db->select('m_no');
	$results = $this->db->get('receipts');
	return $results->result_array();

	}
	
// 	public function get_saving_receipt_details($id, $towards) {
//     $this->db->select('*');
//     $this->db->where('towards', $towards); // Use dynamically passed 'towards' value
//     $this->db->where('m_no', $id);

//     $results = $this->db->get('receipts');
//     return $results->result_array();
// }


    public function get_receipts_by_member($m_no, $towards) {
        $this->db->select('*');
        $this->db->from('receipts');
        $this->db->where('m_no', $m_no);
        $this->db->where('towards', $towards);
        $query = $this->db->get();
        return $query->result_array();
    }

    // Fetch total savings based on m_no and towards
    public function get_total_savings($m_no, $towards) {
        $this->db->select('SUM(totalamount) AS total_savings');
        $this->db->from('receipts');
        $this->db->where('m_no', $m_no);
        $this->db->where('towards', $towards);
        $query = $this->db->get();
        return $query->row()->total_savings ?? 0;
    }

	
// public function get_saving_receipt_details($id) {
//     $this->db->select('*');
//     $this->db->where('towards', 'Monthly Savings'); // Corrected condition
//     $this->db->where('m_no', $id);

//     $results = $this->db->get('receipts');
//     return $results->result_array();
// }

	
	
	
public function get_image($id){

	$this->db->select('image');
	$this->db->where('m_no',$id);
	$result = $this->db->get('members');
	return $result->result_array();
}



// public function add_savings($data) {

// $result = $this->db->insert('receipts',$data);
// $count = $this->db->affected_rows();

// if ($count >=1) {

// 	return true;

// }

// else {

// 	return false;

// }

// }

public function add_savings($data)
{
    // Step 1: Insert into 'receipts'
    $this->db->insert('receipts', $data);
    $count = $this->db->affected_rows();

    if ($count < 1) {
        return false;
    }

    // Step 2: Check if the savings is for 'Monthly Savings'
    if (isset($data['towards']) && $data['towards'] === 'Monthly Savings') {
        $m_no      = $data['m_no'];
        // $companyId = $data['company_id'];
        $amount    = $data['amount'];
        $mname     = isset($data['membername']) ? $data['membername'] : '';

        // Check if record exists
        $this->db
            ->select('added')
            ->from('cvmacs_trans_savings')
            // ->where('company_id', )
            ->where('m_no', $m_no);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            // Record exists, update it
            $row      = $query->row();
            $newAdded = $row->added + $amount;

            $this->db
                // ->where('company_id', $companyId)
                ->where('m_no', $m_no)
                ->update('cvmacs_trans_savings', [
                    'added'      => $newAdded,
                    'closingbal' => $newAdded,  // Optional: recalculate if needed
                    'lastpaiddate'  => date('Y-m-d'),
                ]);
        } else {
            // No record found, insert new
            $insertData = [
                'company_id'    => '270601',
                'm_no'          => $m_no,
                'mname'         => $mname,
                'openingbal'    => 0,
                'added'         => $amount,
                'intonopening'  => 0,
                'intonadded'    => 0,
                'bonusamount'   => 0,
                'withdrawal'    => 0,
                'closingbal'    => $amount,
                'roi'           => 0,
                'lastpaiddate'  => date('Y-m-d'),
                'oploanpending' => 0,
                'remarks'       => ''
            ];

            $this->db->insert('cvmacs_trans_savings', $insertData);
        }
    }

    return true;
}


// =========select Recipts============

public function get_all_savings() {

    $this->db->where('towards !=', 'Loan Repayment');	
	$this->db->order_by('receipts_id','DESC');
	$this->db->limit('20');
	$result = $this->db->get('receipts');
	return $result->result_array();

}

public function get_receipt_by_id($id)
{
    $this->db->where('receipts_id', $id);
    $query = $this->db->get('receipts');
    return $query->row_array(); // Return single record as an array
}


public function get_all_loans() {

	$this->db->order_by('receipts_id','DESC');
	$this->db->limit('100');
	$this->db->where('towards','Loan Repayment');
	$result = $this->db->get('receipts');
	return $result->result_array();

}


public function get_withdraw_list() {

	$this->db->where('isactive','0');
	
	$result= $this->db->get('members');
	return $result->result_array();

}


// // ==============edit Recipts==============

// public function get_recipts($id) {

// 	$this->db->where('id',$id);

// 	$result = $this->db->get('recipts');
// 	return $result->result_array();

// }

// // =============update Recipts=================

public function update_recipts($receipt_id, $data) {
    $this->db->where('receipts_id', $receipt_id);
    $this->db->update('receipts', $data);

    if ($this->db->affected_rows() >= 0) {
        return true;
    } else {
        echo "Error: " . $this->db->error(); // ❌ Print SQL error if any
        return false;
    }
}




// =============delete Recipts==============

// public function delete_recipts($recipts_id) {

// 	$this->db->where('id',$recipts_id);
// 	$this->db->delete('recipts');

// 	$count = $this->db->affected_rows();

// 	if ($count >=1) {
		
// 		return true;
// 	}

// 	else {

// 		return false;
// 	}

// }


public function Saving_Receipts_List(){

// $sql = "SELECT * FROM `payments` WHERE (date BETWEEN '$from_dt' AND '$to_dt');";

// $result = $this->db->query($sql);

// return $result->result_array();


    $start = $this->input->post('start');
    $length = $this->input->post('length');
    $search = $this->input->post('search')['value'];

    if (!empty($search)) {
        $this->db->group_start(); // open bracket
        $this->db->like('m_no', $search);
        $this->db->or_like('membername', $search);
        $this->db->or_like('receipts_id ', $search);
        $this->db->or_like('receipt_date', $search);
        $this->db->group_end(); // close bracket
    }

    $this->db->from('receipts');
     // OR condition for 'towards'
    $this->db->group_start(); // open bracket for OR condition
    $this->db->where('towards', 'Monthly Savings');
    $this->db->or_where('towards', 'Form Sales');
    $this->db->or_where('towards', 'Admission Fee');
    $this->db->group_end(); // close bracket for OR condition
   $this->db->order_by('receipts_id ', 'DESC');
//    $this->db->limit(100);

    $totalFiltered = $this->db->count_all_results('', false);

    $this->db->limit($length, $start);
    $query = $this->db->get();
    $data = $query->result_array();

    $formatted = [];
    $sno = $start + 1;
    foreach ($data as $row) {
        $row['sno'] = $sno++;
        $formatted[] = $row;
    }

     $output = [
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => $totalFiltered,
        "recordsFiltered" => $totalFiltered,
        "data" => $formatted
    ];

    header('Content-Type: application/json');
    echo json_encode($output);
    exit();

}


}




 ?>