<div class="pxl-download-box pxl-download-box1 <?php echo esc_attr($settings['style']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <?php
    $is_new = \Elementor\Icons_Manager::is_migration_allowed();
    if(isset($settings['icons']) && !empty($settings['icons']) && count($settings['icons'])): ?>
        <h4 class="pxl-download--title">
            <?php if(!empty($settings['download_text'])) { ?>
                <i class="far fa-scrubber"></i>
                <span><?php echo pxl_print_html($settings['download_text']); ?></span>
            <?php } else { ?>
                <i class="far fa-scrubber"></i>
                <span><?php echo pxl_print_html('Download', 'agria'); ?></span>
            <?php } ?>
        </h4>
        <div class="pxl-download--button">
            <?php foreach ($settings['icons'] as $key => $value):
                $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                $widget->add_render_attribute( $icon_key, [
                    'class' => $value['pxl_icon'],
                    'aria-hidden' => 'true',
                ] );
                $link_key = $widget->get_repeater_setting_key( 'download_link', 'value', $key );
                if ( ! empty( $value['download_link']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $value['download_link']['url'] );

                    if ( $value['download_link']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $value['download_link']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                <?php if ( ! empty( $value['pxl_icon'] ) ) : ?>
                    <a class="elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                        <?php if ( $is_new ):
                            if(!empty($value['btn_text'])) {
                                echo pxl_print_html($value['btn_text']);
                            }
                            \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                        elseif(!empty($value['pxl_icon'])): ?>
                            <?php if(!empty($value['btn_text'])) {
                                echo pxl_print_html($value['btn_text']);
                            } ?>
                            <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                        <?php endif; ?>
                    </a>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
    <?php if(!empty($settings['social'])): ?>
        <h4 class="pxl-share--title">
            <?php if(!empty($settings['download_text'])) { ?>
                <i class="far fa-scrubber"></i>
                <span><?php echo pxl_print_html($settings['share_text']); ?></span>
            <?php } else { ?>
                <i class="far fa-scrubber"></i>
                <span><?php echo pxl_print_html('Share Now', 'agria'); ?></span>
            <?php } ?>
        </h4>
        <div class="pxl-item--social">
            <?php $team_social = json_decode($settings['social'], true);
            foreach ($team_social as $value): ?>
                <a href="<?php echo esc_url($value['url']); ?>" target="_blank">
                    <i class="<?php echo esc_attr($value['icon']); ?>"></i>
                </a>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>