<?php
// make some configs
if(!function_exists('agria_configs')){
    function agria_configs($value){

        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'agria').' ('.agria()->get_opt('primary_color', '#06150a').')',
                    'value' => agria()->get_opt('primary_color', '#06150a')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'agria').' ('.agria()->get_opt('secondary_color', '#008929').')',
                    'value' => agria()->get_opt('secondary_color', '#008929')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'agria').' ('.agria()->get_opt('third_color', '#232323').')',
                    'value' => agria()->get_opt('third_color', '#232323')
                ],
                'fourth'   => [
                    'title' => esc_html__('Fourth', 'agria').' ('.agria()->get_opt('fourth_color', '#FFFFFF').')',
                    'value' => agria()->get_opt('fourth_color', '#FFFFFF')
                ],
                'fifth'   => [
                    'title' => esc_html__('Fifth', 'agria').' ('.agria()->get_opt('fifth_color', '#B4E330').')',
                    'value' => agria()->get_opt('fifth_color', '#B4E330')
                ],
                'sixth'   => [
                    'title' => esc_html__('Sixth', 'agria').' ('.agria()->get_opt('sixth_color', '#E2E9E0').')',
                    'value' => agria()->get_opt('sixth_color', '#E2E9E0')
                ],
                'seventh'   => [
                    'title' => esc_html__('Seventh', 'agria').' ('.agria()->get_opt('seventh_color', '#484848').')',
                    'value' => agria()->get_opt('seventh_color', '#484848')
                ],
                'eighth'   => [
                    'title' => esc_html__('Eighth', 'agria').' ('.agria()->get_opt('eighth_color', '#272727').')',
                    'value' => agria()->get_opt('eighth_color', '#272727')
                ],
                'bglight'   => [
                    'title' => esc_html__('Background Light', 'agria').' ('.agria()->get_opt('bg_light_color', '#FFFFFF').')',
                    'value' => agria()->get_opt('bg_light_color', '#FFFFFF')
                ],
                'bgdark'   => [
                    'title' => esc_html__('Background Dark', 'agria').' ('.agria()->get_opt('bg_dark_color', '#232323').')',
                    'value' => agria()->get_opt('bg_dark_color', '#232323')
                ]
            ],
            'link' => [
                'color' => agria()->get_opt('link_color', ['regular' => '#232323'])['regular'],
                'color-hover'   => agria()->get_opt('link_color', ['hover' => '#008929'])['hover'],
                'color-active'  => agria()->get_opt('link_color', ['active' => '#008929'])['active'],
            ],
            'gradient' => [
                'color-from' => agria()->get_opt('gradient_color', ['from' => '#232323'])['from'],
                'color-to' => agria()->get_opt('gradient_color', ['to' => '#008929'])['to'],
            ],

        ];
        return $configs[$value];
    }
}
if(!function_exists('agria_inline_styles')) {
    function agria_inline_styles() {

        $theme_colors      = agria_configs('theme_colors');
        $link_color        = agria_configs('link');
        $gradient_color        = agria_configs('gradient');

        ob_start();
        echo ':root{';

            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  agria_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            }
        echo '}';

        return ob_get_clean();

    }
}
