<?php

class PxlButton_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_button';
    protected $title = 'Button Pxl';
    protected $icon = 'eicon-button';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"text","label":"Text","type":"text","default":"Click Here"},{"name":"link","label":"Link","type":"url","default":{"url":"#"}},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"fa fa-align-left"},"center":{"title":"Center","icon":"fa fa-align-center"},"right":{"title":"Right","icon":"fa fa-align-right"},"justify":{"title":"Justified","icon":"fa fa-align-justify"}},"prefix_class":"elementor-align-","default":"","selectors":{"{{WRAPPER}} .pxl-button":"text-align: {{VALUE}}"}}]},{"name":"section_style_button","label":"Button Normal","tab":"style","controls":[{"name":"btn_style","label":"Style","type":"select","options":{"btn-default":"Default","btn-style2":"Style 2"},"default":"btn-default"},{"name":"btn_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-button .btn"},{"name":"btn_border_radius","label":"Border Radius","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-button .btn, {{WRAPPER}} .pxl-button .btn:after":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-button .btn"},{"name":"btn_padding","label":"Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-button .btn":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"btn_size","label":"Button Size (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-button .btn":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};"}},{"name":"btn_width","label":"Button Width","type":"choose","control_type":"responsive","options":{"100%":{"title":"100%","icon":"eicon-text-align-justify"},"auto":{"title":"Auto","icon":"eicon-h-align-stretch"}},"selectors":{"{{WRAPPER}} .pxl-button .btn":"width: {{VALUE}};"}},{"name":"color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button .btn":"color: {{VALUE}};"},"separator":"before"},{"name":"btn_bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button .btn":"background-color: {{VALUE}};"}},{"name":"border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button .btn:after":"border-color: {{VALUE}};"},"condition":{"btn_style":"btn-default"}},{"name":"border_color2","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button .btn:before":"border-color: {{VALUE}};","{{WRAPPER}} .pxl-button .btn .top-bottom:before, {{WRAPPER}} .pxl-button .btn .top-bottom:after, {{WRAPPER}} .pxl-button .btn .left-right:before, {{WRAPPER}} .pxl-button .btn .left-right:after":"background-color: {{VALUE}};"},"condition":{"btn_style":"btn-style2"}},{"name":"darkmode_color","label":"Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-button .btn":"color: {{VALUE}};"},"separator":"before"},{"name":"darkmode_btn_bg_color","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-button .btn":"background-color: {{VALUE}};"}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-button .btn:after":"border-color: {{VALUE}};"},"condition":{"btn_style":"btn-default"}},{"name":"darkmode_border_color2","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-button .btn:before":"border-color: {{VALUE}};",".dark-mode {{WRAPPER}} .pxl-button .btn .top-bottom:before, .dark-mode {{WRAPPER}} .pxl-button .btn .top-bottom:after, .dark-mode {{WRAPPER}} .pxl-button .btn .left-right:before, .dark-mode {{WRAPPER}} .pxl-button .btn .left-right:after":"background-color: {{VALUE}};"},"condition":{"btn_style":"btn-style2"}}]},{"name":"section_style_button_hover","label":"Button Hover","tab":"style","controls":[{"name":"button_effect","label":"Effect","type":"select","options":{"":"None","pxl-jump":"Jump","pxl-upscale":"Upscale","pxl-spin":"Spin","pxl-skew":"Skew","pxl-squash":"Squash","pxl-leap":"Leap","pxl-fade":"Fade","pxl-sheen":"Sheen","pxl-xspin":"Xspin","pxl-pop":"Pop"},"default":""},{"name":"color_hover","label":"Color Hover","type":"color","selectors":{"{{WRAPPER}} .pxl-button .btn:hover":"color: {{VALUE}};"}},{"name":"btn_bg_color_hover","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button .btn:hover":"background-color: {{VALUE}};"}},{"name":"border_color_hover","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button .btn:hover:after":"border-color: {{VALUE}};"}},{"name":"darkmode_color_hover","label":"Color Hover (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-button .btn:hover":"color: {{VALUE}};"},"separator":"before"},{"name":"darkmode_btn_bg_color_hover","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-button .btn:hover":"background-color: {{VALUE}};"}},{"name":"darkmode_border_color_hover","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-button .btn:hover:after":"border-color: {{VALUE}};"}},{"name":"btn_box_shadow_hover","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-button .btn:hover"}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"},{"name":"pxl_animate_duration","label":"Animation Duration","type":"number","min":0,"step":0.1000000000000000055511151231257827021181583404541015625,"default":1.1999999999999999555910790149937383830547332763671875,"description":"Default 1.2s"}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}