<?php

class PxlCounter_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_counter';
    protected $title = 'Counter Pxl';
    protected $icon = 'eicon-counter-circle';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/glansadesigns.com\/testing\/risenew\/wp-content\/themes\/agria\/elements\/templates\/pxl_counter\/img-layout\/layout1.jpg"}}}]},{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"title","label":"Title","type":"text","label_block":true},{"name":"starting_number","label":"Starting Number","type":"number","default":1},{"name":"ending_number","label":"Ending Number","type":"number","default":100},{"name":"prefix","label":"Number Prefix","type":"text","default":""},{"name":"suffix","label":"Number Suffix","type":"text","default":""},{"name":"thousand_separator_char","label":"Number Separator","type":"select","options":{"":"Default",".":"Dot"," ":"Space"},"default":""},{"name":"counter_style","label":"Counter Style","type":"select","options":{"style1":"Style 1","style2":"Style 2"},"default":"style1","condition":{"layout":"1"}},{"name":"box_width","label":"Box Max Width","type":"slider","control_type":"responsive","size_units":["%","px"],"default":{"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-counter":"text-align: {{VALUE}}; justify-content: {{VALUE}};"}}]},{"name":"section_style_title","label":"Title","tab":"style","condition":{"layout":"1"},"controls":[{"name":"title_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-title":"color: {{VALUE}};"}},{"name":"darkmode_title_color","label":"Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-counter .pxl--item-title":"color: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl--item-title"},{"name":"title_width","label":"Title Max Width","type":"slider","control_type":"responsive","size_units":["%","px"],"default":{"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl--item-title":"max-width: {{SIZE}}{{UNIT}};"}}]},{"name":"section_style_number","label":"Number","tab":"style","controls":[{"name":"text_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-prefix,\r\n                                {{WRAPPER}} .pxl-counter .pxl--counter-value,\r\n                                {{WRAPPER}} .pxl-counter .pxl--counter-suffix":"color: {{VALUE}};"}},{"name":"darkmode_text_color","label":"Text Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-counter .pxl--counter-prefix,\r\n                                .dark-mode {{WRAPPER}} .pxl-counter .pxl--counter-value,\r\n                                .dark-mode {{WRAPPER}} .pxl-counter .pxl--counter-suffix":"color: {{VALUE}};"}},{"name":"text_hover_color","label":"Text Hover Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter:hover .pxl--counter-prefix,\r\n                                {{WRAPPER}} .pxl-counter:hover .pxl--counter-value,\r\n                                {{WRAPPER}} .pxl-counter:hover .pxl--counter-suffix":"color: {{VALUE}};"}},{"name":"darkmode_text_hover_color","label":"Text Hover Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-counter:hover .pxl--counter-prefix,\r\n                                .dark-mode {{WRAPPER}} .pxl-counter:hover .pxl--counter-value,\r\n                                .dark-mode {{WRAPPER}} .pxl-counter:hover .pxl--counter-suffix":"color: {{VALUE}};"}},{"name":"prefix_typography","label":"Prefix Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-prefix"},{"name":"number_typography","label":"Number Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-value"},{"name":"suffix_typography","label":"Suffix Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-suffix","condition":{"counter_style":"style1"}},{"name":"suffix_typography2","label":"Suffix Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl--counter-number .pxl--counter-value:after","condition":{"counter_style":"style2"}},{"name":"number_min_width","label":"Number Min Width","type":"slider","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-value":"min-width: {{SIZE}}{{UNIT}};"}},{"name":"number_padding","label":"Number Padding","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl--counter-number":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"duration","label":"Animation Duration","type":"number","default":2000,"min":100,"step":100}]},{"name":"section_style_box","label":"Box","tab":"style","controls":[{"name":"bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter":"background-color: {{VALUE}};"}},{"name":"darkmode_bg_color","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-counter":"background-color: {{VALUE}};"}},{"name":"box_padding","label":"Box Padding","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-counter":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_border_radius","label":"Border Radius","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-counter":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"border_type","label":"Border Type","type":"select","options":{"":"None","solid":"Solid","double":"Double","dotted":"Dotted","dashed":"Dashed","groove":"Groove"},"selectors":{"{{WRAPPER}} .pxl-counter":"border-style: {{VALUE}};"}},{"name":"border_width","label":"Border Width","type":"dimensions","selectors":{"{{WRAPPER}} .pxl-counter":"border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"border_type!":""},"responsive":true},{"name":"border_color","label":"Border Color","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-counter":"border-color: {{VALUE}};"},"condition":{"border_type!":""}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-counter":"border-color: {{VALUE}};"},"condition":{"border_type!":""}},{"name":"box_position","label":"Position","type":"select","control_type":"responsive","options":{"":"Default","relative":"Relative","absolute":"Absolute"},"default":"","separator":"before","selectors":{"{{WRAPPER}}":"position: {{VALUE}};"}},{"name":"box_horizontal_orientation","label":"Horizontal Orientation","type":"choose","control_type":"responsive","options":{"start":{"title":"Left","icon":"eicon-h-align-left"},"end":{"title":"Right","icon":"eicon-h-align-right"}},"toggle":false,"default":"start","render_type":"ui","condition":{"box_position!":""}},{"name":"box_offset_x","label":"Offset X","type":"slider","control_type":"responsive","range":{"px":{"min":-1000,"max":1000,"step":1},"%":{"min":-200,"max":200},"vw":{"min":-200,"max":200},"vh":{"min":-200,"max":200}},"default":{"size":"0"},"size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}}":"left: {{SIZE}}{{UNIT}}"},"condition":{"box_horizontal_orientation":"start","box_position!":""}},{"name":"box_offset_x_end","label":"Offset X","type":"slider","control_type":"responsive","range":{"px":{"min":-1000,"max":1000,"step":1},"%":{"min":-200,"max":200},"vw":{"min":-200,"max":200},"vh":{"min":-200,"max":200}},"default":{"size":"0"},"size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}}":"right: {{SIZE}}{{UNIT}}"},"condition":{"box_horizontal_orientation":"end","box_position!":""}},{"name":"box_vertical_orientation","label":"Vertical Orientation","type":"choose","control_type":"responsive","options":{"start":{"title":"Top","icon":"eicon-v-align-top"},"end":{"title":"Bottom","icon":"eicon-v-align-bottom"}},"toggle":false,"default":"start","render_type":"ui","condition":{"box_position!":""}},{"name":"box_offset_y","label":"Offset Y","type":"slider","control_type":"responsive","range":{"px":{"min":-1000,"max":1000,"step":1},"%":{"min":-200,"max":200},"vw":{"min":-200,"max":200},"vh":{"min":-200,"max":200}},"default":{"size":"0"},"size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}}":"top: {{SIZE}}{{UNIT}}"},"condition":{"box_vertical_orientation":"start","box_position!":""}},{"name":"box_offset_y_end","label":"Offset Y","type":"slider","control_type":"responsive","range":{"px":{"min":-1000,"max":1000,"step":1},"%":{"min":-200,"max":200},"vw":{"min":-200,"max":200},"vh":{"min":-200,"max":200}},"default":{"size":"0"},"size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}}":"bottom: {{SIZE}}{{UNIT}}"},"condition":{"box_vertical_orientation":"end","box_position!":""}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"},{"name":"pxl_animate_duration","label":"Animation Duration","type":"number","min":0,"step":0.1000000000000000055511151231257827021181583404541015625,"default":1.1999999999999999555910790149937383830547332763671875,"description":"Default 1.2s"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'elementor-waypoints','jquery-numerator','pxl-counter','agria-counter' );
}